<?php
/**
 * OptiCore SaaS - Proveedor Model
 */

class Proveedor extends BaseModel
{
    protected string $table = 'proveedores';

    public function getAll(int $page = 1, string $search = '', string $tipo = ''): array
    {
        $params = [$this->empresaScope()];
        $where  = 'empresa_id = ?';

        if ($search) {
            $where   .= ' AND (nombre LIKE ? OR rut LIKE ? OR contacto LIKE ?)';
            $s        = "%$search%";
            $params[] = $s; $params[] = $s; $params[] = $s;
        }
        if ($tipo) {
            $where   .= ' AND tipo = ?';
            $params[] = $tipo;
        }

        $sql = "SELECT * FROM `{$this->table}` WHERE $where ORDER BY nombre ASC";
        return $this->db->paginate($sql, $params, $page);
    }

    public function getActivos(string $tipo = ''): array
    {
        $params = [$this->empresaScope()];
        $where  = "empresa_id = ? AND estado = 'activo'";

        if ($tipo) {
            $where   .= ' AND (tipo = ? OR tipo = \'ambos\')';
            $params[] = $tipo;
        }

        return $this->db->fetchAll(
            "SELECT * FROM `{$this->table}` WHERE $where ORDER BY nombre",
            $params
        );
    }

    public function getById(int $id): array|false
    {
        return $this->db->fetchOne(
            "SELECT * FROM `{$this->table}` WHERE id = ? AND empresa_id = ?",
            [$id, $this->empresaScope()]
        );
    }

    public function crear(array $data): int
    {
        return $this->db->insert($this->table, [
            'empresa_id'  => $this->empresaScope(),
            'nombre'      => trim($data['nombre']),
            'rut'         => trim($data['rut'] ?? '') ?: null,
            'contacto'    => trim($data['contacto'] ?? '') ?: null,
            'telefono'    => trim($data['telefono'] ?? '') ?: null,
            'email'       => trim($data['email'] ?? '') ?: null,
            'direccion'   => trim($data['direccion'] ?? '') ?: null,
            'tipo'        => $data['tipo'] ?? 'proveedor',
            'estado'      => $data['estado'] ?? 'activo',
        ]);
    }

    public function actualizar(int $id, array $data): int
    {
        return $this->update($id, [
            'nombre'    => trim($data['nombre']),
            'rut'       => trim($data['rut'] ?? '') ?: null,
            'contacto'  => trim($data['contacto'] ?? '') ?: null,
            'telefono'  => trim($data['telefono'] ?? '') ?: null,
            'email'     => trim($data['email'] ?? '') ?: null,
            'direccion' => trim($data['direccion'] ?? '') ?: null,
            'tipo'      => $data['tipo'] ?? 'proveedor',
            'estado'    => $data['estado'] ?? 'activo',
        ]);
    }

    public function eliminar(int $id): int
    {
        return $this->update($id, ['estado' => 'inactivo']);
    }
}
