<?php /* Vista: Crear Empresa */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-building-add text-primary me-2"></i>Nueva Empresa</h4>
    <a href="<?= BASE_URL ?>/empresas" class="btn btn-outline-secondary btn-sm">
        <i class="bi bi-arrow-left me-1"></i>Volver
    </a>
</div>

<div class="row justify-content-center">
<div class="col-lg-9">
<div class="card border-0 shadow-sm">
<div class="card-body p-4">
<form method="POST" action="<?= BASE_URL ?>/empresas" enctype="multipart/form-data">
    <?= csrf_field() ?>

    <div class="row g-3">
        <!-- Datos básicos -->
        <div class="col-12"><h6 class="text-muted fw-semibold border-bottom pb-2">Datos de la Empresa</h6></div>

        <div class="col-md-8">
            <label class="form-label fw-medium">Nombre <span class="text-danger">*</span></label>
            <input type="text" name="nombre" class="form-control" value="<?= clean(post('nombre')) ?>" required autofocus>
        </div>
        <div class="col-md-4">
            <label class="form-label fw-medium">Plan <span class="text-danger">*</span></label>
            <select name="plan_id" class="form-select" required>
                <option value="">Seleccionar...</option>
                <?php foreach ($planes as $p): ?>
                <option value="<?= $p['id'] ?>" <?= post('plan_id') == $p['id'] ? 'selected' : '' ?>>
                    <?= clean($p['nombre']) ?> - <?= formatMoney($p['precio_mensual']) ?>/mes
                </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="col-md-6">
            <label class="form-label fw-medium">Razón Social</label>
            <input type="text" name="razon_social" class="form-control" value="<?= clean(post('razon_social')) ?>">
        </div>
        <div class="col-md-3">
            <label class="form-label fw-medium">RUT / NIT</label>
            <input type="text" name="rut" class="form-control" value="<?= clean(post('rut')) ?>">
        </div>
        <div class="col-md-3">
            <label class="form-label fw-medium">Moneda</label>
            <select name="moneda" class="form-select">
                <option value="CLP" <?= post('moneda', 'CLP') === 'CLP' ? 'selected' : '' ?>>CLP - Peso Chileno</option>
                <option value="USD" <?= post('moneda') === 'USD' ? 'selected' : '' ?>>USD - Dólar</option>
                <option value="PEN" <?= post('moneda') === 'PEN' ? 'selected' : '' ?>>PEN - Sol Peruano</option>
                <option value="COP" <?= post('moneda') === 'COP' ? 'selected' : '' ?>>COP - Peso Colombiano</option>
                <option value="MXN" <?= post('moneda') === 'MXN' ? 'selected' : '' ?>>MXN - Peso Mexicano</option>
                <option value="ARS" <?= post('moneda') === 'ARS' ? 'selected' : '' ?>>ARS - Peso Argentino</option>
            </select>
        </div>

        <!-- Contacto -->
        <div class="col-12"><h6 class="text-muted fw-semibold border-bottom pb-2 mt-2">Contacto</h6></div>

        <div class="col-md-6">
            <label class="form-label fw-medium">Email <span class="text-danger">*</span></label>
            <input type="email" name="email" class="form-control" value="<?= clean(post('email')) ?>" required>
        </div>
        <div class="col-md-3">
            <label class="form-label fw-medium">Teléfono</label>
            <input type="text" name="telefono" class="form-control" value="<?= clean(post('telefono')) ?>">
        </div>
        <div class="col-md-3">
            <label class="form-label fw-medium">País</label>
            <input type="text" name="pais" class="form-control" value="<?= clean(post('pais', 'Chile')) ?>">
        </div>

        <div class="col-md-8">
            <label class="form-label fw-medium">Dirección</label>
            <input type="text" name="direccion" class="form-control" value="<?= clean(post('direccion')) ?>">
        </div>
        <div class="col-md-4">
            <label class="form-label fw-medium">Ciudad</label>
            <input type="text" name="ciudad" class="form-control" value="<?= clean(post('ciudad')) ?>">
        </div>

        <!-- Personalización -->
        <div class="col-12"><h6 class="text-muted fw-semibold border-bottom pb-2 mt-2">Personalización</h6></div>

        <div class="col-md-3">
            <label class="form-label fw-medium">Color Primario</label>
            <input type="color" name="color_primario" class="form-control form-control-color w-100"
                   value="<?= clean(post('color_primario', '#0d6efd')) ?>">
        </div>
        <div class="col-md-4">
            <label class="form-label fw-medium">Estado</label>
            <select name="estado" class="form-select">
                <option value="prueba"     <?= post('estado', 'prueba') === 'prueba'     ? 'selected' : '' ?>>Prueba</option>
                <option value="activa"     <?= post('estado') === 'activa'     ? 'selected' : '' ?>>Activa</option>
                <option value="suspendida" <?= post('estado') === 'suspendida' ? 'selected' : '' ?>>Suspendida</option>
            </select>
        </div>

        <div class="col-12 d-flex gap-2 justify-content-end mt-2">
            <a href="<?= BASE_URL ?>/empresas" class="btn btn-outline-secondary">Cancelar</a>
            <button type="submit" class="btn btn-primary px-4">
                <i class="bi bi-check-lg me-1"></i>Crear Empresa
            </button>
        </div>
    </div>
</form>
</div>
</div>
</div>
</div>
