<?php /* Vista: Nueva Forma de Pago */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-credit-card text-primary me-2"></i>Nueva Forma de Pago</h4>
    <a href="<?= BASE_URL ?>/formas-pago" class="btn btn-outline-secondary btn-sm">
        <i class="bi bi-arrow-left me-1"></i>Volver
    </a>
</div>

<div class="row justify-content-center">
<div class="col-lg-6">
<div class="card border-0 shadow-sm">
<div class="card-body p-4">
<form method="POST" action="<?= BASE_URL ?>/formas-pago">
    <?= csrf_field() ?>
    <div class="row g-3">
        <div class="col-md-8">
            <label class="form-label fw-medium">Nombre <span class="text-danger">*</span></label>
            <input type="text" name="nombre" class="form-control"
                   value="<?= clean(post('nombre')) ?>" required autofocus
                   placeholder="Ej: Efectivo, Tarjeta Visa...">
        </div>
        <div class="col-md-4">
            <label class="form-label fw-medium">Tipo <span class="text-danger">*</span></label>
            <select name="tipo" class="form-select" required>
                <option value="">Seleccionar...</option>
                <option value="efectivo"        <?= post('tipo') === 'efectivo'        ? 'selected' : '' ?>>Efectivo</option>
                <option value="tarjeta_debito"  <?= post('tipo') === 'tarjeta_debito'  ? 'selected' : '' ?>>Tarjeta Débito</option>
                <option value="tarjeta_credito" <?= post('tipo') === 'tarjeta_credito' ? 'selected' : '' ?>>Tarjeta Crédito</option>
                <option value="transferencia"   <?= post('tipo') === 'transferencia'   ? 'selected' : '' ?>>Transferencia</option>
                <option value="cheque"          <?= post('tipo') === 'cheque'          ? 'selected' : '' ?>>Cheque</option>
                <option value="otro"            <?= post('tipo') === 'otro'            ? 'selected' : '' ?>>Otro</option>
            </select>
        </div>
        <div class="col-12">
            <label class="form-label fw-medium">Descripción</label>
            <textarea name="descripcion" class="form-control" rows="2"
                      placeholder="Descripción opcional..."><?= clean(post('descripcion')) ?></textarea>
        </div>
        <div class="col-md-6">
            <div class="form-check form-switch mt-2">
                <input class="form-check-input" type="checkbox" name="requiere_referencia" value="1"
                       id="requiereRef" <?= post('requiere_referencia') ? 'checked' : '' ?>>
                <label class="form-check-label fw-medium" for="requiereRef">
                    Requiere número de referencia
                </label>
                <div class="form-text">Ej: número de transferencia, voucher, etc.</div>
            </div>
        </div>
        <div class="col-md-6">
            <label class="form-label fw-medium">Estado</label>
            <select name="estado" class="form-select">
                <option value="activa"   <?= post('estado', 'activa') === 'activa'   ? 'selected' : '' ?>>Activa</option>
                <option value="inactiva" <?= post('estado') === 'inactiva' ? 'selected' : '' ?>>Inactiva</option>
            </select>
        </div>
        <div class="col-12 d-flex gap-2 justify-content-end mt-2">
            <a href="<?= BASE_URL ?>/formas-pago" class="btn btn-outline-secondary">Cancelar</a>
            <button type="submit" class="btn btn-primary px-4">
                <i class="bi bi-check-lg me-1"></i>Crear Forma de Pago
            </button>
        </div>
    </div>
</form>
</div>
</div>
</div>
</div>
