<?php /* Vista: Órdenes de Laboratorio */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-eyeglasses text-primary me-2"></i>Órdenes de Laboratorio</h4>
    <?php if (can('laboratorio.crear')): ?>
    <a href="<?= BASE_URL ?>/laboratorio/create" class="btn btn-primary">
        <i class="bi bi-plus-lg me-1"></i>Nueva Orden
    </a>
    <?php endif; ?>
</div>

<!-- Filtros -->
<div class="card border-0 shadow-sm mb-3">
    <div class="card-body py-2">
        <form method="GET" action="<?= BASE_URL ?>/laboratorio" class="d-flex gap-2 flex-wrap align-items-center">
            <input type="text" name="q" class="form-control" style="max-width:220px"
                   placeholder="Buscar orden..." value="<?= clean($filtros['q'] ?? '') ?>">
            <select name="estado" class="form-select" style="max-width:160px">
                <option value="">Todos los estados</option>
                <option value="recibido"   <?= ($filtros['estado'] ?? '') === 'recibido'   ? 'selected' : '' ?>>Recibido</option>
                <option value="en_proceso" <?= ($filtros['estado'] ?? '') === 'en_proceso' ? 'selected' : '' ?>>En Proceso</option>
                <option value="listo"      <?= ($filtros['estado'] ?? '') === 'listo'      ? 'selected' : '' ?>>Listo</option>
                <option value="entregado"  <?= ($filtros['estado'] ?? '') === 'entregado'  ? 'selected' : '' ?>>Entregado</option>
                <option value="cancelado"  <?= ($filtros['estado'] ?? '') === 'cancelado'  ? 'selected' : '' ?>>Cancelado</option>
            </select>
            <input type="date" name="desde" class="form-control" style="max-width:150px"
                   value="<?= clean($filtros['desde'] ?? '') ?>">
            <input type="date" name="hasta" class="form-control" style="max-width:150px"
                   value="<?= clean($filtros['hasta'] ?? '') ?>">
            <button type="submit" class="btn btn-outline-primary"><i class="bi bi-search"></i></button>
            <a href="<?= BASE_URL ?>/laboratorio" class="btn btn-outline-secondary"><i class="bi bi-x-lg"></i></a>
        </form>
    </div>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                    <tr>
                        <th>Correlativo</th>
                        <th>Paciente</th>
                        <th>Proveedor Lab.</th>
                        <th>Descripción</th>
                        <th>F. Recepción</th>
                        <th>F. Entrega Est.</th>
                        <th>Estado</th>
                        <th class="text-end">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($ordenes as $orden): ?>
                <?php
                $estadoClases = [
                    'recibido'   => 'bg-secondary',
                    'en_proceso' => 'bg-warning text-dark',
                    'listo'      => 'bg-success',
                    'entregado'  => 'bg-primary',
                    'cancelado'  => 'bg-danger',
                ];
                $estadoLabels = [
                    'recibido'   => 'Recibido',
                    'en_proceso' => 'En Proceso',
                    'listo'      => 'Listo',
                    'entregado'  => 'Entregado',
                    'cancelado'  => 'Cancelado',
                ];
                $cls = $estadoClases[$orden['estado']] ?? 'bg-secondary';
                $lbl = $estadoLabels[$orden['estado']] ?? $orden['estado'];
                ?>
                <tr>
                    <td><span class="badge bg-light text-dark border fw-bold"><?= clean($orden['correlativo']) ?></span></td>
                    <td class="fw-semibold"><?= clean($orden['paciente_nombre'] ?? '-') ?></td>
                    <td class="text-muted small"><?= clean($orden['proveedor_nombre'] ?? '-') ?></td>
                    <td class="text-muted small"><?= truncate(clean($orden['descripcion']), 40) ?></td>
                    <td class="text-muted small"><?= $orden['fecha_recepcion'] ? date('d/m/Y', strtotime($orden['fecha_recepcion'])) : '-' ?></td>
                    <td class="text-muted small">
                        <?php if (!empty($orden['fecha_entrega_estimada'])): ?>
                        <?php $vencida = $orden['estado'] !== 'entregado' && $orden['fecha_entrega_estimada'] < date('Y-m-d'); ?>
                        <span class="<?= $vencida ? 'text-danger fw-semibold' : '' ?>">
                            <?= date('d/m/Y', strtotime($orden['fecha_entrega_estimada'])) ?>
                            <?= $vencida ? '<i class="bi bi-exclamation-triangle-fill ms-1"></i>' : '' ?>
                        </span>
                        <?php else: ?>-<?php endif; ?>
                    </td>
                    <td><span class="badge <?= $cls ?>"><?= $lbl ?></span></td>
                    <td class="text-end">
                        <div class="btn-group btn-group-sm">
                            <a href="<?= BASE_URL ?>/laboratorio/<?= $orden['id'] ?>"
                               class="btn btn-outline-secondary" title="Ver detalle">
                                <i class="bi bi-eye"></i>
                            </a>
                            <?php if (can('laboratorio.editar')): ?>
                            <a href="<?= BASE_URL ?>/laboratorio/<?= $orden['id'] ?>/edit"
                               class="btn btn-outline-primary" title="Editar">
                                <i class="bi bi-pencil"></i>
                            </a>
                            <?php endif; ?>
                        </div>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php if (empty($ordenes)): ?>
                <tr>
                    <td colspan="8" class="text-center text-muted py-4">
                        <i class="bi bi-eyeglasses fs-3 d-block mb-2 opacity-25"></i>
                        No hay órdenes de laboratorio registradas.
                    </td>
                </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php if (!empty($pagination) && $pagination['last_page'] > 1): ?>
    <div class="card-footer bg-white d-flex justify-content-between align-items-center">
        <small class="text-muted">
            Mostrando <?= $pagination['from'] ?>–<?= $pagination['to'] ?> de <?= $pagination['total'] ?>
        </small>
        <?= paginationLinks($pagination, BASE_URL . '/laboratorio') ?>
    </div>
    <?php endif; ?>
</div>
