<?php
/**
 * OptiCore SaaS - Layout de Autenticación
 */
$flashMsgs = getFlash();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= clean($title ?? 'Acceso') ?> | <?= APP_NAME ?></title>

    <!-- Bootstrap 5.3 -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <!-- App CSS -->
    <link rel="stylesheet" href="<?= asset('css/app.css') ?>">
</head>
<body class="auth-body">

<div class="auth-wrapper d-flex align-items-center justify-content-center min-vh-100">
    <div class="auth-card">

        <!-- Logo / Brand -->
        <div class="text-center mb-4">
            <div class="auth-logo mb-3">
                <i class="bi bi-eye-fill text-primary" style="font-size: 3rem;"></i>
            </div>
            <h1 class="h3 fw-bold text-dark"><?= APP_NAME ?></h1>
            <p class="text-muted small">Sistema de Gestión para Ópticas</p>
        </div>

        <!-- Flash messages -->
        <?php foreach ($flashMsgs as $flash): ?>
        <div class="alert alert-<?= $flash['type'] === 'error' ? 'danger' : $flash['type'] ?> alert-dismissible fade show" role="alert">
            <i class="bi bi-<?= match($flash['type']) {
                'success' => 'check-circle',
                'error'   => 'exclamation-triangle',
                'warning' => 'exclamation-circle',
                default   => 'info-circle'
            } ?> me-2"></i>
            <?= $flash['message'] ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
        <?php endforeach; ?>

        <!-- Contenido de la vista -->
        <?= $content ?>

        <!-- Footer -->
        <div class="text-center mt-4">
            <small class="text-muted">
                <?= APP_NAME ?> v<?= APP_VERSION ?> &copy; <?= date('Y') ?>
            </small>
        </div>

    </div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
