<?php /* Vista: Editar Producto */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-pencil text-primary me-2"></i>Editar Producto</h4>
    <a href="<?= BASE_URL ?>/productos" class="btn btn-outline-secondary btn-sm">
        <i class="bi bi-arrow-left me-1"></i>Volver
    </a>
</div>

<div class="row justify-content-center">
<div class="col-lg-9">
<div class="card border-0 shadow-sm">
<div class="card-body p-4">
<form method="POST" action="<?= BASE_URL ?>/productos/<?= $producto['id'] ?>" enctype="multipart/form-data">
    <?= csrf_field() ?>
    <div class="row g-3">
        <div class="col-12"><h6 class="text-muted fw-semibold border-bottom pb-2">Información del Producto</h6></div>

        <div class="col-md-8">
            <label class="form-label fw-medium">Nombre <span class="text-danger">*</span></label>
            <input type="text" name="nombre" class="form-control" value="<?= clean($producto['nombre']) ?>" required>
        </div>
        <div class="col-md-4">
            <label class="form-label fw-medium">Código / SKU</label>
            <input type="text" name="sku" class="form-control" value="<?= clean($producto['sku'] ?? '') ?>">
        </div>

        <div class="col-md-4">
            <label class="form-label fw-medium">Categoría</label>
            <select name="categoria_id" class="form-select">
                <option value="">— Sin categoría —</option>
                <?php foreach ($categorias as $cat): ?>
                <option value="<?= $cat['id'] ?>"
                    <?= ($producto['categoria_id'] ?? '') == $cat['id'] ? 'selected' : '' ?>>
                    <?= clean($cat['nombre']) ?>
                </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-4">
            <label class="form-label fw-medium">Marca</label>
            <select name="marca_id" class="form-select">
                <option value="">— Sin marca —</option>
                <?php foreach ($marcas as $m): ?>
                <option value="<?= $m['id'] ?>"
                    <?= ($producto['marca_id'] ?? '') == $m['id'] ? 'selected' : '' ?>>
                    <?= clean($m['nombre']) ?>
                </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-4">
            <label class="form-label fw-medium">Proveedor</label>
            <select name="proveedor_id" class="form-select">
                <option value="">— Sin proveedor —</option>
                <?php foreach ($proveedores as $pv): ?>
                <option value="<?= $pv['id'] ?>"
                    <?= ($producto['proveedor_id'] ?? '') == $pv['id'] ? 'selected' : '' ?>>
                    <?= clean($pv['nombre']) ?>
                </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="col-12">
            <label class="form-label fw-medium">Descripción</label>
            <textarea name="descripcion" class="form-control" rows="2"><?= clean($producto['descripcion'] ?? '') ?></textarea>
        </div>

        <div class="col-12"><h6 class="text-muted fw-semibold border-bottom pb-2 mt-2">Precios y Stock</h6></div>

        <div class="col-md-3">
            <label class="form-label fw-medium">Precio Costo</label>
            <div class="input-group">
                <span class="input-group-text">$</span>
                <input type="number" name="precio_costo" class="form-control"
                       value="<?= $producto['precio_costo'] ?>" min="0" step="0.01">
            </div>
        </div>
        <div class="col-md-3">
            <label class="form-label fw-medium">Precio Venta <span class="text-danger">*</span></label>
            <div class="input-group">
                <span class="input-group-text">$</span>
                <input type="number" name="precio_venta" class="form-control"
                       value="<?= $producto['precio_venta'] ?>" min="0" step="0.01" required>
            </div>
        </div>
        <div class="col-md-3">
            <label class="form-label fw-medium">Stock Mínimo</label>
            <input type="number" name="stock_minimo" class="form-control"
                   value="<?= $producto['stock_minimo'] ?>" min="0">
        </div>
        <div class="col-md-3">
            <label class="form-label fw-medium">Tipo <span class="text-danger">*</span></label>
            <select name="tipo" class="form-select" required>
                <option value="otro"      <?= ($producto['tipo'] ?? '') === 'otro'      ? 'selected' : '' ?>>Otro</option>
                <option value="marco"     <?= ($producto['tipo'] ?? '') === 'marco'     ? 'selected' : '' ?>>Marco / Armazón</option>
                <option value="lente"     <?= ($producto['tipo'] ?? '') === 'lente'     ? 'selected' : '' ?>>Lente</option>
                <option value="solucion"  <?= ($producto['tipo'] ?? '') === 'solucion'  ? 'selected' : '' ?>>Solución</option>
                <option value="accesorio" <?= ($producto['tipo'] ?? '') === 'accesorio' ? 'selected' : '' ?>>Accesorio</option>
                <option value="servicio"  <?= ($producto['tipo'] ?? '') === 'servicio'  ? 'selected' : '' ?>>Servicio</option>
            </select>
        </div>

        <div class="col-12"><h6 class="text-muted fw-semibold border-bottom pb-2 mt-2">Imagen y Estado</h6></div>

        <div class="col-md-6">
            <label class="form-label fw-medium">Imagen</label>
            <?php if ($producto['imagen']): ?>
            <div class="mb-2">
                <img src="<?= BASE_URL . '/' . $producto['imagen'] ?>" height="80" class="rounded border" alt="Imagen actual">
                <div class="form-text">Imagen actual. Sube una nueva para reemplazarla.</div>
            </div>
            <?php endif; ?>
            <input type="file" name="imagen" class="form-control" accept="image/*" id="inputImagen">
            <div class="mt-2">
                <img id="previewImagen" src="" alt="" class="rounded border d-none" style="max-height:80px">
            </div>
        </div>
        <div class="col-md-3">
            <label class="form-label fw-medium">Estado</label>
            <select name="estado" class="form-select">
                <option value="activo"   <?= $producto['estado'] === 'activo'   ? 'selected' : '' ?>>Activo</option>
                <option value="inactivo" <?= $producto['estado'] === 'inactivo' ? 'selected' : '' ?>>Inactivo</option>
            </select>
        </div>

        <div class="col-12 d-flex gap-2 justify-content-end mt-2">
            <a href="<?= BASE_URL ?>/productos" class="btn btn-outline-secondary">Cancelar</a>
            <button type="submit" class="btn btn-primary px-4">
                <i class="bi bi-check-lg me-1"></i>Actualizar Producto
            </button>
        </div>
    </div>
</form>
</div>
</div>
</div>
</div>

<script>
document.getElementById('inputImagen').addEventListener('change', function () {
    const preview = document.getElementById('previewImagen');
    if (this.files && this.files[0]) {
        const reader = new FileReader();
        reader.onload = e => { preview.src = e.target.result; preview.classList.remove('d-none'); };
        reader.readAsDataURL(this.files[0]);
    }
});
</script>
