<?php /* Vista: Productos */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-box-seam text-primary me-2"></i>Productos</h4>
    <?php if (can('productos.crear')): ?>
    <a href="<?= BASE_URL ?>/productos/create" class="btn btn-primary">
        <i class="bi bi-plus-lg me-1"></i>Nuevo Producto
    </a>
    <?php endif; ?>
</div>

<!-- Filtros -->
<div class="card border-0 shadow-sm mb-3">
    <div class="card-body py-2">
        <form method="GET" action="<?= BASE_URL ?>/productos" class="d-flex gap-2 flex-wrap align-items-center">
            <input type="text" name="q" class="form-control" style="max-width:260px"
                   placeholder="Buscar por nombre o código..." value="<?= clean(get('q')) ?>">
            <select name="categoria" class="form-select" style="max-width:180px">
                <option value="">Todas las categorías</option>
                <?php foreach ($categorias as $cat): ?>
                <option value="<?= clean($cat) ?>" <?= get('categoria') === $cat ? 'selected' : '' ?>><?= clean($cat) ?></option>
                <?php endforeach; ?>
            </select>
            <select name="estado" class="form-select" style="max-width:140px">
                <option value="">Todos</option>
                <option value="activo"   <?= get('estado') === 'activo'   ? 'selected' : '' ?>>Activos</option>
                <option value="inactivo" <?= get('estado') === 'inactivo' ? 'selected' : '' ?>>Inactivos</option>
            </select>
            <button type="submit" class="btn btn-outline-primary"><i class="bi bi-search"></i></button>
            <?php if (get('q') || get('categoria') || get('estado')): ?>
            <a href="<?= BASE_URL ?>/productos" class="btn btn-outline-secondary"><i class="bi bi-x-lg"></i></a>
            <?php endif; ?>
        </form>
    </div>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                    <tr>
                        <th>Producto</th>
                        <th>Código</th>
                        <th>Categoría</th>
                        <th>Marca</th>
                        <th>Precio Venta</th>
                        <th>Stock</th>
                        <th>Estado</th>
                        <th class="text-end">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($productos as $p): ?>
                <tr>
                    <td>
                        <div class="d-flex align-items-center gap-2">
                            <?php if ($p['imagen']): ?>
                            <img src="<?= BASE_URL . '/' . $p['imagen'] ?>" width="36" height="36"
                                 class="rounded object-fit-cover border" alt="">
                            <?php else: ?>
                            <div class="rounded bg-light d-flex align-items-center justify-content-center border"
                                 style="width:36px;height:36px">
                                <i class="bi bi-box text-muted"></i>
                            </div>
                            <?php endif; ?>
                            <span class="fw-semibold small"><?= clean($p['nombre']) ?></span>
                        </div>
                    </td>
                    <td class="text-muted small font-monospace"><?= clean($p['codigo'] ?? '-') ?></td>
                    <td class="small"><?= clean($p['categoria'] ?? '-') ?></td>
                    <td class="small text-muted"><?= clean($p['marca'] ?? '-') ?></td>
                    <td class="fw-medium small"><?= formatMoney($p['precio_venta'], Auth::moneda()) ?></td>
                    <td>
                        <?php
                        $stockTotal = $p['stock_total'] ?? 0;
                        $stockMin   = $p['stock_minimo'] ?? 0;
                        $color = $stockTotal <= 0 ? 'danger' : ($stockTotal <= $stockMin ? 'warning' : 'success');
                        ?>
                        <span class="badge bg-<?= $color ?>"><?= $stockTotal ?></span>
                    </td>
                    <td><?= statusBadge($p['estado']) ?></td>
                    <td class="text-end">
                        <div class="btn-group btn-group-sm">
                            <?php if (can('productos.editar')): ?>
                            <a href="<?= BASE_URL ?>/productos/<?= $p['id'] ?>/edit" class="btn btn-outline-primary">
                                <i class="bi bi-pencil"></i>
                            </a>
                            <?php endif; ?>
                            <?php if (can('stock.ver')): ?>
                            <a href="<?= BASE_URL ?>/stock/kardex?producto_id=<?= $p['id'] ?>" class="btn btn-outline-secondary" title="Kardex">
                                <i class="bi bi-journal-text"></i>
                            </a>
                            <?php endif; ?>
                            <?php if (can('productos.eliminar')): ?>
                            <form method="POST" action="<?= BASE_URL ?>/productos/<?= $p['id'] ?>/delete"
                                  data-confirm="¿Eliminar producto?">
                                <?= csrf_field() ?>
                                <button type="submit" class="btn btn-outline-danger"><i class="bi bi-trash"></i></button>
                            </form>
                            <?php endif; ?>
                        </div>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php if (empty($productos)): ?>
                <tr>
                    <td colspan="8" class="text-center text-muted py-4">No hay productos registrados.</td>
                </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
