<?php /* Vista: Imprimir Receta - usa layout print */ ?>

<style>
    .receta-header { border-bottom: 2px solid #333; padding-bottom: 12px; margin-bottom: 16px; }
    .receta-logo   { max-height: 60px; }
    .grad-table    { width: 100%; border-collapse: collapse; margin: 12px 0; }
    .grad-table th,
    .grad-table td { border: 1px solid #999; padding: 6px 10px; text-align: center; font-size: 13px; }
    .grad-table th { background: #f0f0f0; font-weight: 600; }
    .ojo-label     { font-weight: 700; font-size: 14px; }
    .od-color      { color: #0d6efd; }
    .oi-color      { color: #198754; }
    .firma-box     { border-top: 1px solid #333; width: 200px; margin-top: 40px; padding-top: 4px; text-align: center; font-size: 12px; }
</style>

<!-- Encabezado empresa -->
<div class="receta-header d-flex justify-content-between align-items-start">
    <div>
        <?php if ($empresa['logo']): ?>
        <img src="<?= BASE_URL . '/' . $empresa['logo'] ?>" class="receta-logo mb-1" alt="Logo">
        <?php endif; ?>
        <h5 class="mb-0 fw-bold"><?= clean($empresa['nombre']) ?></h5>
        <?php if ($empresa['direccion']): ?>
        <div class="small text-muted"><?= clean($empresa['direccion']) ?><?= $empresa['ciudad'] ? ', ' . clean($empresa['ciudad']) : '' ?></div>
        <?php endif; ?>
        <?php if ($empresa['telefono']): ?>
        <div class="small text-muted">Tel: <?= clean($empresa['telefono']) ?></div>
        <?php endif; ?>
        <?php if ($empresa['email']): ?>
        <div class="small text-muted"><?= clean($empresa['email']) ?></div>
        <?php endif; ?>
    </div>
    <div class="text-end">
        <h4 class="fw-bold mb-1">RECETA ÓPTICA</h4>
        <div class="small">N° <?= str_pad($receta['id'], 6, '0', STR_PAD_LEFT) ?></div>
        <div class="small">Fecha: <?= formatDate($receta['fecha']) ?></div>
    </div>
</div>

<!-- Datos del paciente -->
<div class="row mb-3">
    <div class="col-8">
        <table style="width:100%;font-size:13px">
            <tr>
                <td style="width:120px;color:#666">Paciente:</td>
                <td><strong><?= clean($receta['paciente_nombre']) ?></strong></td>
            </tr>
            <?php if ($receta['paciente_rut']): ?>
            <tr>
                <td style="color:#666">RUT:</td>
                <td><?= clean($receta['paciente_rut']) ?></td>
            </tr>
            <?php endif; ?>
            <?php if ($receta['paciente_telefono']): ?>
            <tr>
                <td style="color:#666">Teléfono:</td>
                <td><?= clean($receta['paciente_telefono']) ?></td>
            </tr>
            <?php endif; ?>
        </table>
    </div>
    <div class="col-4 text-end">
        <?php if ($receta['tipo_lente']): ?>
        <div class="small"><strong>Tipo:</strong> <?= ucfirst($receta['tipo_lente']) ?></div>
        <?php endif; ?>
        <?php if ($receta['uso']): ?>
        <div class="small"><strong>Uso:</strong> <?= str_replace('_', '/', ucfirst($receta['uso'])) ?></div>
        <?php endif; ?>
        <?php if ($receta['dp']): ?>
        <div class="small"><strong>D.P.:</strong> <?= $receta['dp'] ?> mm</div>
        <?php endif; ?>
    </div>
</div>

<!-- Tabla de graduación -->
<table class="grad-table">
    <thead>
        <tr>
            <th style="width:60px">Ojo</th>
            <th>Esfera</th>
            <th>Cilindro</th>
            <th>Eje</th>
            <th>Adición</th>
            <th>A.V.</th>
            <th>Prisma</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td><span class="ojo-label od-color">OD</span></td>
            <td class="font-monospace"><?= formatReceta($receta['od_esfera']) ?></td>
            <td class="font-monospace"><?= formatReceta($receta['od_cilindro']) ?></td>
            <td><?= $receta['od_eje'] ? $receta['od_eje'] . '°' : '-' ?></td>
            <td class="font-monospace"><?= formatReceta($receta['od_adicion']) ?></td>
            <td><?= clean($receta['od_av'] ?? '-') ?></td>
            <td><?= clean($receta['od_prisma'] ?? '-') ?></td>
        </tr>
        <tr>
            <td><span class="ojo-label oi-color">OI</span></td>
            <td class="font-monospace"><?= formatReceta($receta['oi_esfera']) ?></td>
            <td class="font-monospace"><?= formatReceta($receta['oi_cilindro']) ?></td>
            <td><?= $receta['oi_eje'] ? $receta['oi_eje'] . '°' : '-' ?></td>
            <td class="font-monospace"><?= formatReceta($receta['oi_adicion']) ?></td>
            <td><?= clean($receta['oi_av'] ?? '-') ?></td>
            <td><?= clean($receta['oi_prisma'] ?? '-') ?></td>
        </tr>
    </tbody>
</table>

<?php if ($receta['observaciones']): ?>
<div style="font-size:13px;margin-top:10px;padding:8px;background:#f9f9f9;border:1px solid #ddd;border-radius:4px">
    <strong>Observaciones:</strong> <?= clean($receta['observaciones']) ?>
</div>
<?php endif; ?>

<!-- Firma -->
<div class="d-flex justify-content-end mt-4">
    <div class="firma-box">
        <?php if ($receta['optometrista_nombre']): ?>
        <div><?= clean($receta['optometrista_nombre']) ?></div>
        <?php endif; ?>
        <div>Optometrista</div>
    </div>
</div>

<!-- Pie de página -->
<div style="margin-top:30px;font-size:11px;color:#999;text-align:center;border-top:1px solid #eee;padding-top:8px">
    <?= clean($empresa['nombre']) ?> — Receta válida por 12 meses desde la fecha de emisión.
</div>
