<?php /* Vista: Reporte de Stock */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-boxes text-warning me-2"></i>Reporte de Stock</h4>
    <a href="<?= BASE_URL ?>/reportes" class="btn btn-outline-secondary btn-sm">
        <i class="bi bi-arrow-left me-1"></i>Reportes
    </a>
</div>

<!-- Filtros -->
<div class="card border-0 shadow-sm mb-4">
    <div class="card-body">
        <form method="GET" action="<?= BASE_URL ?>/reportes/stock" class="row g-2 align-items-end">
            <div class="col-sm-6 col-md-3">
                <label class="form-label small fw-medium">Sucursal</label>
                <select name="sucursal_id" class="form-select form-select-sm">
                    <option value="">Todas</option>
                    <?php foreach ($sucursales as $s): ?>
                    <option value="<?= $s['id'] ?>" <?= get('sucursal_id') == $s['id'] ? 'selected' : '' ?>>
                        <?= clean($s['nombre']) ?>
                    </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-sm-6 col-md-3">
                <label class="form-label small fw-medium">Categoría</label>
                <select name="categoria" class="form-select form-select-sm">
                    <option value="">Todas</option>
                    <?php foreach ($categorias as $cat): ?>
                    <option value="<?= clean($cat) ?>" <?= get('categoria') === $cat ? 'selected' : '' ?>>
                        <?= clean($cat) ?>
                    </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-sm-6 col-md-3">
                <label class="form-label small fw-medium">Filtrar</label>
                <select name="alerta" class="form-select form-select-sm">
                    <option value="">Todos los productos</option>
                    <option value="bajo"  <?= get('alerta') === 'bajo'  ? 'selected' : '' ?>>Stock Bajo</option>
                    <option value="sin"   <?= get('alerta') === 'sin'   ? 'selected' : '' ?>>Sin Stock</option>
                    <option value="ok"    <?= get('alerta') === 'ok'    ? 'selected' : '' ?>>Stock OK</option>
                </select>
            </div>
            <div class="col-sm-6 col-md-3 d-flex gap-2 align-items-end">
                <button type="submit" class="btn btn-primary btn-sm">
                    <i class="bi bi-search me-1"></i>Filtrar
                </button>
                <a href="<?= BASE_URL ?>/reportes/stock/export?<?= http_build_query($_GET) ?>"
                   class="btn btn-outline-success btn-sm">
                    <i class="bi bi-file-earmark-excel me-1"></i>CSV
                </a>
            </div>
        </form>
    </div>
</div>

<!-- KPIs -->
<div class="row g-3 mb-4">
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm text-center py-3">
            <div class="fs-3 fw-bold text-primary"><?= $kpis['total_productos'] ?? 0 ?></div>
            <div class="text-muted small">Total Productos</div>
        </div>
    </div>
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm text-center py-3">
            <div class="fs-3 fw-bold text-success"><?= formatMoney($kpis['valor_inventario'] ?? 0, Auth::moneda()) ?></div>
            <div class="text-muted small">Valor Inventario (costo)</div>
        </div>
    </div>
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm text-center py-3">
            <div class="fs-3 fw-bold text-warning"><?= $kpis['bajo_stock'] ?? 0 ?></div>
            <div class="text-muted small">Bajo Stock</div>
        </div>
    </div>
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm text-center py-3">
            <div class="fs-3 fw-bold text-danger"><?= $kpis['sin_stock'] ?? 0 ?></div>
            <div class="text-muted small">Sin Stock</div>
        </div>
    </div>
</div>

<!-- Tabla de stock -->
<div class="card border-0 shadow-sm">
    <div class="card-header bg-transparent d-flex justify-content-between align-items-center">
        <h6 class="mb-0 fw-semibold">Inventario Actual</h6>
        <span class="badge bg-secondary"><?= count($stock) ?> productos</span>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                    <tr>
                        <th>Producto</th>
                        <th>Categoría</th>
                        <th>Sucursal</th>
                        <th class="text-center">Stock</th>
                        <th class="text-center">Mín.</th>
                        <th class="text-end">Costo Unit.</th>
                        <th class="text-end">Valor Total</th>
                        <th class="text-center">Estado</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($stock as $s): ?>
                <?php
                $alerta = $s['cantidad'] <= 0 ? 'danger' : ($s['cantidad'] <= $s['stock_minimo'] ? 'warning' : 'success');
                ?>
                <tr>
                    <td class="small fw-medium"><?= clean($s['producto_nombre']) ?></td>
                    <td class="small text-muted"><?= clean($s['categoria'] ?? '-') ?></td>
                    <td class="small text-muted"><?= clean($s['sucursal_nombre']) ?></td>
                    <td class="text-center">
                        <span class="badge bg-<?= $alerta ?>"><?= $s['cantidad'] ?></span>
                    </td>
                    <td class="text-center small text-muted"><?= $s['stock_minimo'] ?></td>
                    <td class="text-end small"><?= formatMoney($s['precio_costo'] ?? 0, Auth::moneda()) ?></td>
                    <td class="text-end small fw-medium"><?= formatMoney(($s['precio_costo'] ?? 0) * $s['cantidad'], Auth::moneda()) ?></td>
                    <td class="text-center">
                        <?php if ($s['cantidad'] <= 0): ?>
                            <span class="badge bg-danger">Sin stock</span>
                        <?php elseif ($s['cantidad'] <= $s['stock_minimo']): ?>
                            <span class="badge bg-warning text-dark">Bajo</span>
                        <?php else: ?>
                            <span class="badge bg-success">OK</span>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php if (empty($stock)): ?>
                <tr>
                    <td colspan="8" class="text-center text-muted py-4">No hay productos con los filtros seleccionados.</td>
                </tr>
                <?php endif; ?>
                </tbody>
                <?php if (!empty($stock)): ?>
                <tfoot class="table-light fw-bold">
                    <tr>
                        <td colspan="6" class="text-end">Valor Total Inventario:</td>
                        <td class="text-end text-success"><?= formatMoney($kpis['valor_inventario'] ?? 0, Auth::moneda()) ?></td>
                        <td></td>
                    </tr>
                </tfoot>
                <?php endif; ?>
            </table>
        </div>
    </div>
</div>
