<?php /* Vista: Roles */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-shield-check text-primary me-2"></i>Roles y Permisos</h4>
    <?php if (can('roles.crear')): ?>
    <a href="<?= BASE_URL ?>/roles/create" class="btn btn-primary">
        <i class="bi bi-plus-lg me-1"></i>Nuevo Rol
    </a>
    <?php endif; ?>
</div>

<div class="row g-3">
<?php foreach ($roles as $rol): ?>
<div class="col-md-6 col-xl-4">
    <div class="card border-0 shadow-sm h-100">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-start mb-2">
                <div>
                    <h6 class="fw-bold mb-0"><?= clean($rol['nombre']) ?></h6>
                    <code class="text-muted small"><?= clean($rol['slug']) ?></code>
                </div>
                <span class="badge bg-secondary"><?= $rol['total_usuarios'] ?> usuario(s)</span>
            </div>
            <?php if ($rol['descripcion']): ?>
            <p class="text-muted small mb-3"><?= clean($rol['descripcion']) ?></p>
            <?php endif; ?>
        </div>
        <div class="card-footer bg-transparent d-flex gap-2">
            <?php if (can('roles.editar')): ?>
            <a href="<?= BASE_URL ?>/roles/<?= $rol['id'] ?>/edit" class="btn btn-sm btn-outline-primary flex-fill">
                <i class="bi bi-pencil me-1"></i>Editar Permisos
            </a>
            <?php endif; ?>
            <?php if (can('roles.eliminar') && !in_array($rol['slug'], ['admin','vendedor','optometrista'])): ?>
            <form method="POST" action="<?= BASE_URL ?>/roles/<?= $rol['id'] ?>/delete"
                  data-confirm="¿Eliminar rol?">
                <?= csrf_field() ?>
                <button type="submit" class="btn btn-sm btn-outline-danger">
                    <i class="bi bi-trash"></i>
                </button>
            </form>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php endforeach; ?>
<?php if (empty($roles)): ?>
<div class="col-12 text-center text-muted py-5">
    <i class="bi bi-shield fs-1 d-block mb-2 opacity-25"></i>
    No hay roles registrados.
</div>
<?php endif; ?>
</div>
