<?php /* Vista: Stock */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-boxes text-primary me-2"></i>Control de Stock</h4>
    <?php if (can('stock.ajustar')): ?>
    <a href="<?= BASE_URL ?>/stock/ajuste" class="btn btn-primary">
        <i class="bi bi-plus-minus me-1"></i>Ajuste de Stock
    </a>
    <?php endif; ?>
</div>

<!-- Filtros -->
<div class="card border-0 shadow-sm mb-3">
    <div class="card-body py-2">
        <form method="GET" action="<?= BASE_URL ?>/stock" class="d-flex gap-2 flex-wrap align-items-center">
            <input type="text" name="q" class="form-control" style="max-width:240px"
                   placeholder="Buscar producto..." value="<?= clean(get('q')) ?>">
            <select name="sucursal_id" class="form-select" style="max-width:200px">
                <option value="">Todas las sucursales</option>
                <?php foreach ($sucursales as $s): ?>
                <option value="<?= $s['id'] ?>" <?= get('sucursal_id') == $s['id'] ? 'selected' : '' ?>>
                    <?= clean($s['nombre']) ?>
                </option>
                <?php endforeach; ?>
            </select>
            <select name="alerta" class="form-select" style="max-width:160px">
                <option value="">Todos</option>
                <option value="bajo" <?= get('alerta') === 'bajo' ? 'selected' : '' ?>>Stock Bajo</option>
                <option value="sin"  <?= get('alerta') === 'sin'  ? 'selected' : '' ?>>Sin Stock</option>
            </select>
            <button type="submit" class="btn btn-outline-primary"><i class="bi bi-search"></i></button>
            <?php if (get('q') || get('sucursal_id') || get('alerta')): ?>
            <a href="<?= BASE_URL ?>/stock" class="btn btn-outline-secondary"><i class="bi bi-x-lg"></i></a>
            <?php endif; ?>
        </form>
    </div>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                    <tr>
                        <th>Producto</th>
                        <th>Código</th>
                        <th>Sucursal</th>
                        <th>Cantidad</th>
                        <th>Mín.</th>
                        <th>Último Mov.</th>
                        <th class="text-end">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($stock as $s): ?>
                <?php
                $alerta = $s['cantidad'] <= 0 ? 'danger' : ($s['cantidad'] <= $s['stock_minimo'] ? 'warning' : '');
                ?>
                <tr class="<?= $alerta ? 'table-' . $alerta . ' bg-opacity-10' : '' ?>">
                    <td>
                        <span class="fw-semibold small"><?= clean($s['producto_nombre']) ?></span>
                        <?php if ($s['categoria']): ?>
                        <div class="text-muted" style="font-size:11px"><?= clean($s['categoria']) ?></div>
                        <?php endif; ?>
                    </td>
                    <td class="text-muted small font-monospace"><?= clean($s['codigo'] ?? '-') ?></td>
                    <td class="small"><?= clean($s['sucursal_nombre']) ?></td>
                    <td>
                        <span class="badge bg-<?= $s['cantidad'] <= 0 ? 'danger' : ($s['cantidad'] <= $s['stock_minimo'] ? 'warning' : 'success') ?> fs-6">
                            <?= $s['cantidad'] ?>
                        </span>
                    </td>
                    <td class="text-muted small"><?= $s['stock_minimo'] ?></td>
                    <td class="text-muted small"><?= $s['updated_at'] ? formatDateTime($s['updated_at']) : '-' ?></td>
                    <td class="text-end">
                        <div class="btn-group btn-group-sm">
                            <a href="<?= BASE_URL ?>/stock/kardex?producto_id=<?= $s['producto_id'] ?>&sucursal_id=<?= $s['sucursal_id'] ?>"
                               class="btn btn-outline-secondary" title="Kardex">
                                <i class="bi bi-journal-text"></i>
                            </a>
                            <?php if (can('stock.ajustar')): ?>
                            <a href="<?= BASE_URL ?>/stock/ajuste?producto_id=<?= $s['producto_id'] ?>&sucursal_id=<?= $s['sucursal_id'] ?>"
                               class="btn btn-outline-primary" title="Ajustar">
                                <i class="bi bi-plus-minus"></i>
                            </a>
                            <?php endif; ?>
                        </div>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php if (empty($stock)): ?>
                <tr>
                    <td colspan="7" class="text-center text-muted py-4">No hay registros de stock.</td>
                </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
