<?php /* Vista: Kardex de Producto */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h4 class="mb-0 fw-bold"><i class="bi bi-journal-text text-primary me-2"></i>Kardex de Stock</h4>
        <?php if ($producto): ?>
        <small class="text-muted"><?= clean($producto['nombre']) ?><?= $producto['codigo'] ? ' [' . clean($producto['codigo']) . ']' : '' ?></small>
        <?php endif; ?>
    </div>
    <a href="<?= BASE_URL ?>/stock" class="btn btn-outline-secondary btn-sm">
        <i class="bi bi-arrow-left me-1"></i>Volver
    </a>
</div>

<!-- Filtros -->
<div class="card border-0 shadow-sm mb-3">
    <div class="card-body py-2">
        <form method="GET" action="<?= BASE_URL ?>/stock/kardex" class="d-flex gap-2 flex-wrap align-items-center">
            <select name="producto_id" class="form-select" style="max-width:260px" required>
                <option value="">Seleccionar producto...</option>
                <?php foreach ($productos as $p): ?>
                <option value="<?= $p['id'] ?>" <?= get('producto_id') == $p['id'] ? 'selected' : '' ?>>
                    <?= clean($p['nombre']) ?>
                </option>
                <?php endforeach; ?>
            </select>
            <select name="sucursal_id" class="form-select" style="max-width:200px">
                <option value="">Todas las sucursales</option>
                <?php foreach ($sucursales as $s): ?>
                <option value="<?= $s['id'] ?>" <?= get('sucursal_id') == $s['id'] ? 'selected' : '' ?>>
                    <?= clean($s['nombre']) ?>
                </option>
                <?php endforeach; ?>
            </select>
            <input type="date" name="desde" class="form-control" style="max-width:150px" value="<?= clean(get('desde')) ?>">
            <input type="date" name="hasta" class="form-control" style="max-width:150px" value="<?= clean(get('hasta')) ?>">
            <button type="submit" class="btn btn-outline-primary"><i class="bi bi-search"></i></button>
        </form>
    </div>
</div>

<?php if ($producto): ?>
<!-- Resumen de stock actual -->
<div class="row g-3 mb-3">
    <?php foreach ($stockActual as $sa): ?>
    <div class="col-sm-6 col-md-4 col-lg-3">
        <div class="card border-0 shadow-sm text-center py-3">
            <div class="fs-3 fw-bold <?= $sa['cantidad'] <= 0 ? 'text-danger' : ($sa['cantidad'] <= $sa['stock_minimo'] ? 'text-warning' : 'text-success') ?>">
                <?= $sa['cantidad'] ?>
            </div>
            <div class="text-muted small"><?= clean($sa['sucursal_nombre']) ?></div>
        </div>
    </div>
    <?php endforeach; ?>
</div>

<!-- Tabla kardex -->
<div class="card border-0 shadow-sm">
    <div class="card-header bg-transparent d-flex justify-content-between align-items-center">
        <h6 class="mb-0 fw-semibold">Historial de Movimientos</h6>
        <span class="badge bg-secondary"><?= count($movimientos) ?> registros</span>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-sm table-hover align-middle mb-0">
                <thead class="table-light">
                    <tr>
                        <th>Fecha</th>
                        <th>Tipo</th>
                        <th>Entrada</th>
                        <th>Salida</th>
                        <th>Saldo</th>
                        <th>Costo Unit.</th>
                        <th>Referencia</th>
                        <th>Sucursal</th>
                        <th>Usuario</th>
                    </tr>
                </thead>
                <tbody>
                <?php
                $saldo = 0;
                foreach ($movimientos as $m):
                    $esEntrada = in_array($m['tipo'], ['entrada', 'ajuste']);
                    if ($esEntrada) $saldo += $m['cantidad'];
                    else $saldo -= $m['cantidad'];
                ?>
                <tr>
                    <td class="small text-muted"><?= formatDateTime($m['created_at']) ?></td>
                    <td>
                        <?php
                        $tc = match($m['tipo']) {
                            'entrada'  => 'success',
                            'salida'   => 'danger',
                            'ajuste'   => 'warning',
                            'traslado' => 'info',
                            'venta'    => 'primary',
                            default    => 'secondary',
                        };
                        ?>
                        <span class="badge bg-<?= $tc ?>"><?= $m['tipo'] ?></span>
                    </td>
                    <td class="text-success fw-medium small"><?= $esEntrada ? $m['cantidad'] : '-' ?></td>
                    <td class="text-danger fw-medium small"><?= !$esEntrada ? $m['cantidad'] : '-' ?></td>
                    <td class="fw-bold small"><?= $saldo ?></td>
                    <td class="small text-muted"><?= $m['costo_unitario'] ? formatMoney($m['costo_unitario']) : '-' ?></td>
                    <td class="small text-muted"><?= clean($m['referencia'] ?? '-') ?></td>
                    <td class="small text-muted"><?= clean($m['sucursal_nombre']) ?></td>
                    <td class="small text-muted"><?= clean($m['usuario_nombre'] ?? '-') ?></td>
                </tr>
                <?php endforeach; ?>
                <?php if (empty($movimientos)): ?>
                <tr><td colspan="9" class="text-center text-muted py-3">Sin movimientos para este producto.</td></tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php else: ?>
<div class="text-center text-muted py-5">
    <i class="bi bi-journal-text fs-1 d-block mb-3 opacity-25"></i>
    <p>Selecciona un producto para ver su kardex.</p>
</div>
<?php endif; ?>
