<?php /* Vista: Ajuste de Stock */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-plus-minus text-primary me-2"></i>Ajuste de Stock</h4>
    <a href="<?= BASE_URL ?>/stock" class="btn btn-outline-secondary btn-sm">
        <i class="bi bi-arrow-left me-1"></i>Volver al Stock
    </a>
</div>

<div class="row g-3">
    <!-- Formulario de ajuste -->
    <div class="col-lg-5">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-transparent"><h6 class="mb-0 fw-semibold">Registrar Movimiento</h6></div>
            <div class="card-body">
                <form method="POST" action="<?= BASE_URL ?>/stock/ajuste">
                    <?= csrf_field() ?>
                    <div class="mb-3">
                        <label class="form-label fw-medium">Producto <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <input type="text" id="productoBuscar" class="form-control"
                                   placeholder="Buscar producto..." autocomplete="off"
                                   value="<?= clean($productoSeleccionado['nombre'] ?? '') ?>">
                            <button type="button" class="btn btn-outline-secondary" onclick="limpiarProducto()">
                                <i class="bi bi-x-lg"></i>
                            </button>
                        </div>
                        <input type="hidden" name="producto_id" id="productoId"
                               value="<?= get('producto_id') ?: post('producto_id') ?>" required>
                        <div id="productoSugerencias" class="list-group position-absolute z-3" style="max-width:350px;display:none"></div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-medium">Sucursal <span class="text-danger">*</span></label>
                        <select name="sucursal_id" class="form-select" required>
                            <?php foreach ($sucursales as $s): ?>
                            <option value="<?= $s['id'] ?>"
                                <?= (get('sucursal_id') == $s['id'] || post('sucursal_id') == $s['id'] || Auth::sucursalId() == $s['id']) ? 'selected' : '' ?>>
                                <?= clean($s['nombre']) ?>
                            </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-medium">Tipo de Movimiento <span class="text-danger">*</span></label>
                        <select name="tipo" class="form-select" required>
                            <option value="entrada"  <?= post('tipo') === 'entrada'  ? 'selected' : '' ?>>📦 Entrada (Compra/Recepción)</option>
                            <option value="salida"   <?= post('tipo') === 'salida'   ? 'selected' : '' ?>>📤 Salida (Consumo/Pérdida)</option>
                            <option value="ajuste"   <?= post('tipo', 'ajuste') === 'ajuste'   ? 'selected' : '' ?>>⚖️ Ajuste de Inventario</option>
                            <option value="traslado" <?= post('tipo') === 'traslado' ? 'selected' : '' ?>>🔄 Traslado</option>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-medium">Cantidad <span class="text-danger">*</span></label>
                        <input type="number" name="cantidad" class="form-control"
                               value="<?= clean(post('cantidad', '1')) ?>" min="1" required>
                        <div class="form-text">Para ajuste, ingresa la cantidad final deseada.</div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-medium">Costo Unitario</label>
                        <div class="input-group">
                            <span class="input-group-text">$</span>
                            <input type="number" name="costo_unitario" class="form-control"
                                   value="<?= clean(post('costo_unitario', '0')) ?>" min="0" step="0.01">
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-medium">Referencia / N° Documento</label>
                        <input type="text" name="referencia" class="form-control"
                               value="<?= clean(post('referencia')) ?>" placeholder="Factura, guía, etc.">
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-medium">Observaciones</label>
                        <textarea name="observaciones" class="form-control" rows="2"><?= clean(post('observaciones')) ?></textarea>
                    </div>

                    <button type="submit" class="btn btn-primary w-100">
                        <i class="bi bi-check-lg me-1"></i>Registrar Movimiento
                    </button>
                </form>
            </div>
        </div>
    </div>

    <!-- Últimos movimientos -->
    <div class="col-lg-7">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-transparent"><h6 class="mb-0 fw-semibold">Últimos Movimientos</h6></div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-sm table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Producto</th>
                                <th>Tipo</th>
                                <th>Cant.</th>
                                <th>Sucursal</th>
                                <th>Usuario</th>
                                <th>Fecha</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($movimientos as $m): ?>
                        <tr>
                            <td class="small fw-medium"><?= clean($m['producto_nombre']) ?></td>
                            <td>
                                <?php
                                $tipoColor = match($m['tipo']) {
                                    'entrada'  => 'success',
                                    'salida'   => 'danger',
                                    'ajuste'   => 'warning',
                                    'traslado' => 'info',
                                    default    => 'secondary',
                                };
                                ?>
                                <span class="badge bg-<?= $tipoColor ?>"><?= $m['tipo'] ?></span>
                            </td>
                            <td class="small fw-bold <?= $m['tipo'] === 'salida' ? 'text-danger' : 'text-success' ?>">
                                <?= $m['tipo'] === 'salida' ? '-' : '+' ?><?= $m['cantidad'] ?>
                            </td>
                            <td class="small text-muted"><?= clean($m['sucursal_nombre']) ?></td>
                            <td class="small text-muted"><?= clean($m['usuario_nombre'] ?? '-') ?></td>
                            <td class="small text-muted"><?= formatDateTime($m['created_at']) ?></td>
                        </tr>
                        <?php endforeach; ?>
                        <?php if (empty($movimientos)): ?>
                        <tr><td colspan="6" class="text-center text-muted py-3">Sin movimientos registrados.</td></tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
let searchTimer;
const input  = document.getElementById('productoBuscar');
const hidden = document.getElementById('productoId');
const sugs   = document.getElementById('productoSugerencias');

input.addEventListener('input', function () {
    clearTimeout(searchTimer);
    if (this.value.length < 2) { sugs.style.display = 'none'; return; }
    searchTimer = setTimeout(() => {
        fetch('<?= BASE_URL ?>/productos/buscar?q=' + encodeURIComponent(this.value))
            .then(r => r.json())
            .then(data => {
                sugs.innerHTML = '';
                if (!data.length) { sugs.style.display = 'none'; return; }
                data.forEach(p => {
                    const a = document.createElement('a');
                    a.href = '#';
                    a.className = 'list-group-item list-group-item-action small';
                    a.textContent = p.nombre + (p.codigo ? ' [' + p.codigo + ']' : '');
                    a.addEventListener('click', e => {
                        e.preventDefault();
                        input.value  = p.nombre;
                        hidden.value = p.id;
                        sugs.style.display = 'none';
                    });
                    sugs.appendChild(a);
                });
                sugs.style.display = 'block';
            });
    }, 300);
});

document.addEventListener('click', e => {
    if (!sugs.contains(e.target) && e.target !== input) sugs.style.display = 'none';
});

function limpiarProducto() {
    input.value  = '';
    hidden.value = '';
    sugs.style.display = 'none';
    input.focus();
}
</script>
