<?php /* Vista: Nueva Sucursal */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-shop-window text-primary me-2"></i>Nueva Sucursal</h4>
    <a href="<?= BASE_URL ?>/sucursales" class="btn btn-outline-secondary btn-sm">
        <i class="bi bi-arrow-left me-1"></i>Volver
    </a>
</div>

<div class="row justify-content-center">
<div class="col-lg-7">
<div class="card border-0 shadow-sm">
<div class="card-body p-4">
<form method="POST" action="<?= BASE_URL ?>/sucursales">
    <?= csrf_field() ?>
    <div class="row g-3">

        <?php if (Auth::isSuperAdmin() && !empty($empresas)): ?>
        <div class="col-12">
            <label class="form-label fw-medium">
                <i class="bi bi-building text-primary me-1"></i>Empresa <span class="text-danger">*</span>
            </label>
            <select name="empresa_id" class="form-select" required>
                <option value="">— Seleccionar empresa —</option>
                <?php foreach ($empresas as $emp): ?>
                <option value="<?= $emp['id'] ?>" <?= post('empresa_id') == $emp['id'] ? 'selected' : '' ?>>
                    <?= clean($emp['nombre']) ?>
                </option>
                <?php endforeach; ?>
            </select>
            <div class="form-text text-muted">Solo empresas activas.</div>
        </div>
        <?php endif; ?>

        <div class="col-md-8">
            <label class="form-label fw-medium">Nombre <span class="text-danger">*</span></label>
            <input type="text" name="nombre" class="form-control" value="<?= clean(post('nombre')) ?>" required autofocus>
        </div>
        <div class="col-md-4">
            <label class="form-label fw-medium">Código</label>
            <input type="text" name="codigo" class="form-control" value="<?= clean(post('codigo')) ?>" placeholder="SUC-01">
        </div>
        <div class="col-12">
            <label class="form-label fw-medium">Dirección</label>
            <input type="text" name="direccion" class="form-control" value="<?= clean(post('direccion')) ?>">
        </div>
        <div class="col-md-6">
            <label class="form-label fw-medium">Teléfono</label>
            <input type="text" name="telefono" class="form-control" value="<?= clean(post('telefono')) ?>">
        </div>
        <div class="col-md-6">
            <label class="form-label fw-medium">Email</label>
            <input type="email" name="email" class="form-control" value="<?= clean(post('email')) ?>">
        </div>
        <div class="col-12">
            <label class="form-label fw-medium">Horario de Atención</label>
            <input type="text" name="horario" class="form-control" value="<?= clean(post('horario')) ?>"
                   placeholder="Lun-Vie 9:00-18:00">
        </div>
        <div class="col-md-4">
            <label class="form-label fw-medium">Estado</label>
            <select name="estado" class="form-select">
                <option value="activa"   <?= post('estado', 'activa') === 'activa'   ? 'selected' : '' ?>>Activa</option>
                <option value="inactiva" <?= post('estado') === 'inactiva' ? 'selected' : '' ?>>Inactiva</option>
            </select>
        </div>
        <div class="col-12 d-flex gap-2 justify-content-end mt-2">
            <a href="<?= BASE_URL ?>/sucursales" class="btn btn-outline-secondary">Cancelar</a>
            <button type="submit" class="btn btn-primary px-4">
                <i class="bi bi-check-lg me-1"></i>Crear Sucursal
            </button>
        </div>
    </div>
</form>
</div>
</div>
</div>
</div>
