<?php /* Vista: Ventas */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-receipt text-primary me-2"></i>Ventas</h4>
    <?php if (can('ventas.crear')): ?>
    <a href="<?= BASE_URL ?>/ventas/create" class="btn btn-primary">
        <i class="bi bi-plus-lg me-1"></i>Nueva Venta
    </a>
    <?php endif; ?>
</div>

<!-- Filtros -->
<div class="card border-0 shadow-sm mb-3">
    <div class="card-body py-2">
        <form method="GET" action="<?= BASE_URL ?>/ventas" class="d-flex gap-2 flex-wrap align-items-center">
            <input type="text" name="q" class="form-control" style="max-width:220px"
                   placeholder="Buscar correlativo o paciente..." value="<?= clean(get('q')) ?>">
            <input type="date" name="desde" class="form-control" style="max-width:150px" value="<?= clean(get('desde')) ?>">
            <input type="date" name="hasta" class="form-control" style="max-width:150px" value="<?= clean(get('hasta')) ?>">
            <select name="estado" class="form-select" style="max-width:140px">
                <option value="">Todos</option>
                <?php foreach (['completada','pendiente','anulada'] as $est): ?>
                <option value="<?= $est ?>" <?= get('estado') === $est ? 'selected' : '' ?>><?= ucfirst($est) ?></option>
                <?php endforeach; ?>
            </select>
            <button type="submit" class="btn btn-outline-primary"><i class="bi bi-search"></i></button>
            <?php if (get('q') || get('desde') || get('hasta') || get('estado')): ?>
            <a href="<?= BASE_URL ?>/ventas" class="btn btn-outline-secondary"><i class="bi bi-x-lg"></i></a>
            <?php endif; ?>
        </form>
    </div>
</div>

<!-- Resumen del día -->
<?php if (!empty($resumenHoy)): ?>
<div class="row g-2 mb-3">
    <div class="col-sm-4">
        <div class="card border-0 bg-success bg-opacity-10 text-center py-2">
            <div class="fw-bold text-success"><?= formatMoney($resumenHoy['total'] ?? 0, Auth::moneda()) ?></div>
            <div class="text-muted small">Total Hoy</div>
        </div>
    </div>
    <div class="col-sm-4">
        <div class="card border-0 bg-primary bg-opacity-10 text-center py-2">
            <div class="fw-bold text-primary"><?= $resumenHoy['cantidad'] ?? 0 ?></div>
            <div class="text-muted small">Ventas Hoy</div>
        </div>
    </div>
    <div class="col-sm-4">
        <div class="card border-0 bg-warning bg-opacity-10 text-center py-2">
            <div class="fw-bold text-warning"><?= formatMoney($resumenHoy['promedio'] ?? 0, Auth::moneda()) ?></div>
            <div class="text-muted small">Ticket Promedio</div>
        </div>
    </div>
</div>
<?php endif; ?>

<div class="card border-0 shadow-sm">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th>Paciente</th>
                        <th>Sucursal</th>
                        <th>Subtotal</th>
                        <th>Descuento</th>
                        <th>Total</th>
                        <th>Estado</th>
                        <th>Fecha</th>
                        <th class="text-end">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($ventas as $v): ?>
                <tr class="<?= $v['estado'] === 'anulada' ? 'opacity-50' : '' ?>">
                    <td class="fw-medium small">
                        <a href="<?= BASE_URL ?>/ventas/<?= $v['id'] ?>" class="text-decoration-none">
                            <?= clean($v['correlativo']) ?>
                        </a>
                    </td>
                    <td class="small"><?= clean($v['paciente_nombre'] ?? 'Sin paciente') ?></td>
                    <td class="small text-muted"><?= clean($v['sucursal_nombre']) ?></td>
                    <td class="small"><?= formatMoney($v['subtotal'], Auth::moneda()) ?></td>
                    <td class="small text-danger"><?= $v['descuento'] > 0 ? '-' . formatMoney($v['descuento'], Auth::moneda()) : '-' ?></td>
                    <td class="fw-bold small"><?= formatMoney($v['total'], Auth::moneda()) ?></td>
                    <td><?= statusBadge($v['estado']) ?></td>
                    <td class="small text-muted"><?= formatDateTime($v['created_at']) ?></td>
                    <td class="text-end">
                        <div class="btn-group btn-group-sm">
                            <a href="<?= BASE_URL ?>/ventas/<?= $v['id'] ?>" class="btn btn-outline-secondary">
                                <i class="bi bi-eye"></i>
                            </a>
                            <a href="<?= BASE_URL ?>/ventas/<?= $v['id'] ?>/print" class="btn btn-outline-dark" target="_blank">
                                <i class="bi bi-printer"></i>
                            </a>
                            <?php if ($v['estado'] !== 'anulada' && can('ventas.anular')): ?>
                            <form method="POST" action="<?= BASE_URL ?>/ventas/<?= $v['id'] ?>/anular"
                                  data-confirm="¿Anular venta <?= clean($v['correlativo']) ?>?">
                                <?= csrf_field() ?>
                                <button type="submit" class="btn btn-outline-danger" title="Anular">
                                    <i class="bi bi-x-circle"></i>
                                </button>
                            </form>
                            <?php endif; ?>
                        </div>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php if (empty($ventas)): ?>
                <tr>
                    <td colspan="9" class="text-center text-muted py-4">No hay ventas registradas.</td>
                </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
