<?php /* Vista: Boleta/Ticket de Venta - usa layout print */ ?>

<style>
    .ticket-header  { border-bottom: 2px solid #333; padding-bottom: 10px; margin-bottom: 12px; }
    .ticket-table   { width: 100%; border-collapse: collapse; font-size: 12px; margin: 10px 0; }
    .ticket-table th,
    .ticket-table td { padding: 4px 8px; }
    .ticket-table th { background: #f0f0f0; font-weight: 600; border-bottom: 1px solid #ccc; }
    .ticket-table td { border-bottom: 1px solid #eee; }
    .ticket-total   { border-top: 2px solid #333; margin-top: 8px; padding-top: 8px; }
    .ticket-footer  { border-top: 1px dashed #999; margin-top: 16px; padding-top: 8px; font-size: 11px; color: #666; text-align: center; }
    .anulada-stamp  { position: fixed; top: 40%; left: 50%; transform: translate(-50%,-50%) rotate(-30deg);
                      font-size: 72px; font-weight: 900; color: rgba(220,53,69,0.15); pointer-events: none; z-index: 0; }
</style>

<?php if ($venta['estado'] === 'anulada'): ?>
<div class="anulada-stamp">ANULADA</div>
<?php endif; ?>

<!-- Encabezado -->
<div class="ticket-header">
    <div class="d-flex justify-content-between align-items-start">
        <div>
            <?php if ($empresa['logo']): ?>
            <img src="<?= BASE_URL . '/' . $empresa['logo'] ?>" height="50" class="mb-1" alt="Logo">
            <?php endif; ?>
            <h5 class="fw-bold mb-0"><?= clean($empresa['nombre']) ?></h5>
            <?php if ($empresa['rut']): ?>
            <div class="small text-muted">RUT: <?= clean($empresa['rut']) ?></div>
            <?php endif; ?>
            <?php if ($empresa['direccion']): ?>
            <div class="small text-muted"><?= clean($empresa['direccion']) ?><?= $empresa['ciudad'] ? ', ' . clean($empresa['ciudad']) : '' ?></div>
            <?php endif; ?>
            <?php if ($empresa['telefono']): ?>
            <div class="small text-muted">Tel: <?= clean($empresa['telefono']) ?></div>
            <?php endif; ?>
        </div>
        <div class="text-end">
            <h5 class="fw-bold mb-1"><?= strtoupper(str_replace('_', ' ', $venta['tipo_documento'] ?? 'BOLETA')) ?></h5>
            <div class="small">N° <?= clean($venta['correlativo']) ?></div>
            <div class="small">Fecha: <?= formatDateTime($venta['created_at']) ?></div>
            <div class="small">Sucursal: <?= clean($venta['sucursal_nombre']) ?></div>
            <?php if ($venta['usuario_nombre']): ?>
            <div class="small">Vendedor: <?= clean($venta['usuario_nombre']) ?></div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Datos del cliente -->
<?php if ($venta['paciente_nombre']): ?>
<div style="font-size:12px;margin-bottom:10px;padding:6px;background:#f9f9f9;border-radius:4px">
    <strong>Cliente:</strong> <?= clean($venta['paciente_nombre']) ?>
    <?php if ($venta['paciente_rut']): ?> — RUT: <?= clean($venta['paciente_rut']) ?><?php endif; ?>
</div>
<?php endif; ?>

<!-- Detalle de productos -->
<table class="ticket-table">
    <thead>
        <tr>
            <th>Producto</th>
            <th class="text-center">Cant.</th>
            <th class="text-end">P. Unit.</th>
            <th class="text-end">Total</th>
        </tr>
    </thead>
    <tbody>
    <?php foreach ($items as $item): ?>
    <tr>
        <td><?= clean($item['producto_nombre']) ?>
            <?php if ($item['descuento'] > 0): ?>
            <span style="font-size:10px;color:#dc3545"> (-<?= $item['descuento'] ?>%)</span>
            <?php endif; ?>
        </td>
        <td class="text-center"><?= $item['cantidad'] ?></td>
        <td class="text-end"><?= formatMoney($item['precio_unitario'], $empresa['moneda']) ?></td>
        <td class="text-end"><?= formatMoney($item['subtotal'], $empresa['moneda']) ?></td>
    </tr>
    <?php endforeach; ?>
    </tbody>
</table>

<!-- Totales -->
<div class="ticket-total">
    <table style="width:100%;font-size:13px">
        <tr>
            <td>Subtotal:</td>
            <td class="text-end"><?= formatMoney($venta['subtotal'], $empresa['moneda']) ?></td>
        </tr>
        <?php if ($venta['descuento'] > 0): ?>
        <tr>
            <td style="color:#dc3545">Descuento:</td>
            <td class="text-end" style="color:#dc3545">-<?= formatMoney($venta['descuento'], $empresa['moneda']) ?></td>
        </tr>
        <?php endif; ?>
        <tr>
            <td><strong style="font-size:15px">TOTAL:</strong></td>
            <td class="text-end"><strong style="font-size:15px"><?= formatMoney($venta['total'], $empresa['moneda']) ?></strong></td>
        </tr>
    </table>
</div>

<!-- Pagos -->
<div style="margin-top:10px;font-size:12px">
    <strong>Forma de pago:</strong>
    <?php foreach ($pagos as $pago): ?>
    <span><?= ucfirst(str_replace('_', ' ', $pago['metodo'])) ?>: <?= formatMoney($pago['monto'], $empresa['moneda']) ?></span>
    <?php endforeach; ?>
</div>

<?php if ($venta['observaciones']): ?>
<div style="margin-top:8px;font-size:11px;color:#666">
    <strong>Notas:</strong> <?= clean($venta['observaciones']) ?>
</div>
<?php endif; ?>

<!-- Pie de página -->
<div class="ticket-footer">
    <p class="mb-1">¡Gracias por su preferencia!</p>
    <p class="mb-0"><?= clean($empresa['nombre']) ?> — <?= clean($empresa['email'] ?? '') ?></p>
    <?php if ($venta['estado'] === 'anulada'): ?>
    <p class="mb-0 text-danger fw-bold mt-1">*** DOCUMENTO ANULADO ***</p>
    <?php endif; ?>
</div>
