-- ============================================================
-- OptiCore SaaS - Migración: Corrección de nombres de permisos
-- Ejecutar en la base de datos opticore existente
-- ============================================================

USE `opticore`;

-- ── Renombrar permisos al formato modulo.accion ───────────────

-- Pacientes
UPDATE `permisos` SET `nombre` = 'pacientes.ver'      WHERE `nombre` = 'ver_pacientes';
UPDATE `permisos` SET `nombre` = 'pacientes.crear'    WHERE `nombre` = 'crear_pacientes';
UPDATE `permisos` SET `nombre` = 'pacientes.editar'   WHERE `nombre` = 'editar_pacientes';
UPDATE `permisos` SET `nombre` = 'pacientes.eliminar' WHERE `nombre` = 'eliminar_pacientes';

-- Recetas
UPDATE `permisos` SET `nombre` = 'recetas.ver'      WHERE `nombre` = 'ver_recetas';
UPDATE `permisos` SET `nombre` = 'recetas.crear'    WHERE `nombre` = 'crear_recetas';
UPDATE `permisos` SET `nombre` = 'recetas.editar'   WHERE `nombre` = 'editar_recetas';
UPDATE `permisos` SET `nombre` = 'recetas.imprimir' WHERE `nombre` = 'imprimir_recetas';

-- Productos
UPDATE `permisos` SET `nombre` = 'productos.ver'      WHERE `nombre` = 'ver_productos';
UPDATE `permisos` SET `nombre` = 'productos.crear'    WHERE `nombre` = 'crear_productos';
UPDATE `permisos` SET `nombre` = 'productos.editar'   WHERE `nombre` = 'editar_productos';
UPDATE `permisos` SET `nombre` = 'productos.eliminar' WHERE `nombre` = 'eliminar_productos';

-- Stock / Inventario
UPDATE `permisos` SET `nombre` = 'stock.ver'       WHERE `nombre` = 'ver_inventario';
UPDATE `permisos` SET `nombre` = 'stock.ajustar'   WHERE `nombre` = 'ajustar_inventario';
UPDATE `permisos` SET `nombre` = 'stock.transferir' WHERE `nombre` = 'transferir_stock';

-- Ventas
UPDATE `permisos` SET `nombre` = 'ventas.ver'          WHERE `nombre` = 'ver_ventas';
UPDATE `permisos` SET `nombre` = 'ventas.crear'        WHERE `nombre` = 'crear_ventas';
UPDATE `permisos` SET `nombre` = 'ventas.editar'       WHERE `nombre` = 'editar_ventas';
UPDATE `permisos` SET `nombre` = 'ventas.anular'       WHERE `nombre` = 'anular_ventas';
UPDATE `permisos` SET `nombre` = 'ventas.cotizaciones' WHERE `nombre` = 'ver_cotizaciones';

-- Caja
UPDATE `permisos` SET `nombre` = 'caja.ver'       WHERE `nombre` = 'ver_caja';
UPDATE `permisos` SET `nombre` = 'caja.abrir'     WHERE `nombre` = 'abrir_caja';
UPDATE `permisos` SET `nombre` = 'caja.cerrar'    WHERE `nombre` = 'cerrar_caja';
UPDATE `permisos` SET `nombre` = 'caja.movimiento' WHERE `nombre` = 'ver_movimientos_caja';

-- Reportes
UPDATE `permisos` SET `nombre` = 'reportes.ver'      WHERE `nombre` = 'ver_reportes';
UPDATE `permisos` SET `nombre` = 'reportes.exportar' WHERE `nombre` = 'exportar_reportes';

-- Usuarios
UPDATE `permisos` SET `nombre` = 'usuarios.ver'      WHERE `nombre` = 'ver_usuarios';
UPDATE `permisos` SET `nombre` = 'usuarios.crear'    WHERE `nombre` = 'crear_usuarios';
UPDATE `permisos` SET `nombre` = 'usuarios.editar'   WHERE `nombre` = 'editar_usuarios';
UPDATE `permisos` SET `nombre` = 'usuarios.eliminar' WHERE `nombre` = 'eliminar_usuarios';

-- Roles
UPDATE `permisos` SET `nombre` = 'roles.ver'       WHERE `nombre` = 'ver_roles';
UPDATE `permisos` SET `nombre` = 'roles.gestionar' WHERE `nombre` = 'gestionar_roles';

-- Sucursales
UPDATE `permisos` SET `nombre` = 'sucursales.ver'      WHERE `nombre` = 'ver_sucursales';
UPDATE `permisos` SET `nombre` = 'sucursales.crear'    WHERE `nombre` = 'crear_sucursales';
UPDATE `permisos` SET `nombre` = 'sucursales.editar'   WHERE `nombre` = 'editar_sucursales';
UPDATE `permisos` SET `nombre` = 'sucursales.eliminar' WHERE `nombre` = 'eliminar_sucursales';

-- Empresa / Config
UPDATE `permisos` SET `nombre` = 'empresa.ver'    WHERE `nombre` = 'ver_config';
UPDATE `permisos` SET `nombre` = 'empresa.editar' WHERE `nombre` = 'editar_config';

-- Laboratorio
UPDATE `permisos` SET `nombre` = 'laboratorio.ver'    WHERE `nombre` = 'ver_laboratorio';
UPDATE `permisos` SET `nombre` = 'laboratorio.crear'  WHERE `nombre` = 'crear_laboratorio';
UPDATE `permisos` SET `nombre` = 'laboratorio.editar' WHERE `nombre` = 'editar_laboratorio';

-- Agenda / Citas
UPDATE `permisos` SET `nombre` = 'citas.ver'    WHERE `nombre` = 'ver_citas';
UPDATE `permisos` SET `nombre` = 'citas.crear'  WHERE `nombre` = 'crear_citas';
UPDATE `permisos` SET `nombre` = 'citas.editar' WHERE `nombre` = 'editar_citas';

-- Proveedores
UPDATE `permisos` SET `nombre` = 'proveedores.ver'       WHERE `nombre` = 'ver_proveedores';
UPDATE `permisos` SET `nombre` = 'proveedores.gestionar' WHERE `nombre` = 'gestionar_proveedores';

-- Otros
UPDATE `permisos` SET `nombre` = 'compras.ver'    WHERE `nombre` = 'ver_compras';
UPDATE `permisos` SET `nombre` = 'documentos.ver' WHERE `nombre` = 'ver_documentos';
UPDATE `permisos` SET `nombre` = 'dashboard.ver'  WHERE `nombre` = 'ver_dashboard';

-- SaaS (superadmin)
UPDATE `permisos` SET `nombre` = 'saas.empresas.ver'      WHERE `nombre` = 'ver_empresas';
UPDATE `permisos` SET `nombre` = 'saas.empresas.crear'    WHERE `nombre` = 'crear_empresas';
UPDATE `permisos` SET `nombre` = 'saas.empresas.editar'   WHERE `nombre` = 'editar_empresas';
UPDATE `permisos` SET `nombre` = 'saas.empresas.eliminar' WHERE `nombre` = 'eliminar_empresas';
UPDATE `permisos` SET `nombre` = 'saas.planes.ver'        WHERE `nombre` = 'ver_planes';
UPDATE `permisos` SET `nombre` = 'saas.planes.gestionar'  WHERE `nombre` = 'gestionar_planes';
UPDATE `permisos` SET `nombre` = 'saas.licencias.ver'     WHERE `nombre` = 'ver_licencias';
UPDATE `permisos` SET `nombre` = 'saas.licencias.gestionar' WHERE `nombre` = 'gestionar_licencias';

-- ── Agregar permisos faltantes ────────────────────────────────
INSERT IGNORE INTO `permisos` (`modulo`, `nombre`, `descripcion`) VALUES
('stock',    'stock.kardex',      'Ver Kardex de Stock'),
('ventas',   'ventas.imprimir',   'Imprimir/Exportar Ventas'),
('reportes', 'reportes.ventas',   'Reporte de Ventas'),
('reportes', 'reportes.stock',    'Reporte de Stock'),
('reportes', 'reportes.caja',     'Reporte de Caja'),
('roles',    'roles.crear',       'Crear Roles'),
('roles',    'roles.editar',      'Editar Roles'),
('roles',    'roles.eliminar',    'Eliminar Roles');

-- ── Asignar nuevos permisos a superadmin (rol_id = 1) ─────────
INSERT IGNORE INTO `rol_permisos` (`rol_id`, `permiso_id`, `granted`)
SELECT 1, id, 1 FROM `permisos`
WHERE `nombre` IN (
    'stock.kardex','ventas.imprimir',
    'reportes.ventas','reportes.stock','reportes.caja',
    'roles.crear','roles.editar','roles.eliminar'
);

-- ── Asignar nuevos permisos a admin_empresa (rol_id = 2) ──────
INSERT IGNORE INTO `rol_permisos` (`rol_id`, `permiso_id`, `granted`)
SELECT 2, id, 1 FROM `permisos`
WHERE `nombre` IN (
    'stock.kardex','ventas.imprimir',
    'reportes.ventas','reportes.stock','reportes.caja',
    'roles.crear','roles.editar','roles.eliminar'
);

-- ── Asignar nuevos permisos a jefe_sucursal (rol_id = 3) ──────
INSERT IGNORE INTO `rol_permisos` (`rol_id`, `permiso_id`, `granted`)
SELECT 3, id, 1 FROM `permisos`
WHERE `nombre` IN (
    'stock.kardex','ventas.imprimir',
    'reportes.ventas','reportes.stock','reportes.caja'
);

-- ── Asignar nuevos permisos a vendedor (rol_id = 4) ───────────
INSERT IGNORE INTO `rol_permisos` (`rol_id`, `permiso_id`, `granted`)
SELECT 4, id, 1 FROM `permisos`
WHERE `nombre` IN ('ventas.imprimir');

-- ── Limpiar caché de sesiones (forzar re-login) ───────────────
-- Los usuarios deberán iniciar sesión nuevamente para cargar los nuevos permisos.

SELECT 'Migración de permisos completada exitosamente.' AS resultado;
