<?php
// Conexión directa sin depender de config/database.php
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
];

try {
    $pdo = new PDO(
        'mysql:host=localhost;port=3306;dbname=opticore;charset=utf8mb4',
        'root',
        'root',
        $options
    );
    echo "DB OK\n";
} catch (Exception $e) {
    die("DB ERROR: " . $e->getMessage() . "\n");
}

// Usuarios
$users = $pdo->query("SELECT id, email, estado, es_superadmin, empresa_id, LEFT(password,30) as pwd_prefix FROM usuarios")->fetchAll();
echo "\n=== USUARIOS ===\n";
foreach ($users as $u) {
    echo "ID:{$u['id']} | {$u['email']} | estado:{$u['estado']} | superadmin:{$u['es_superadmin']} | empresa_id:" . ($u['empresa_id'] ?? 'NULL') . " | pwd:{$u['pwd_prefix']}...\n";
}

// Verificar password
$testEmail = 'josuepazmino@gmail.com';
$testPass  = 'natanael1';
$row = $pdo->prepare("SELECT password, estado FROM usuarios WHERE email = ?");
$row->execute([$testEmail]);
$u = $row->fetch();
if ($u) {
    $ok = password_verify($testPass, $u['password']);
    echo "\n=== VERIFICACION PASSWORD ===\n";
    echo "Email: $testEmail\n";
    echo "Estado: {$u['estado']}\n";
    echo "password_verify('$testPass'): " . ($ok ? "TRUE ✓" : "FALSE ✗") . "\n";
    echo "Hash en BD: {$u['password']}\n";
} else {
    echo "\n=== USUARIO $testEmail NO ENCONTRADO ===\n";
}

// Empresas
$empresas = $pdo->query("SELECT id, nombre, estado FROM empresas")->fetchAll();
echo "\n=== EMPRESAS ===\n";
foreach ($empresas as $e) {
    echo "ID:{$e['id']} | {$e['nombre']} | estado:{$e['estado']}\n";
}
